/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl.task;

import dev.engine_room.flywheel.impl.FlwImpl;
import dev.engine_room.flywheel.impl.task.TaskExecutorImpl;
import dev.engine_room.flywheel.impl.task.ThreadGroupNotifier;
import dev.engine_room.flywheel.impl.task.WaitGroup;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import net.minecraft.class_3532;

public class ParallelTaskExecutor
implements TaskExecutorImpl {
    private static final int MAX_ERRORS_LOGGED_PER_THREAD = 10;
    private final String name;
    private final int threadCount;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final List<WorkerThread> threads = new ArrayList<WorkerThread>();
    private final Deque<Runnable> taskQueue = new ConcurrentLinkedDeque<Runnable>();
    private final ThreadGroupNotifier taskNotifier = new ThreadGroupNotifier();
    private final WaitGroup waitGroup = new WaitGroup();
    private int mainThreadErrorLogLatch = 10;

    public ParallelTaskExecutor(String name, int threadCount) {
        this.name = name;
        this.threadCount = threadCount;
    }

    @Override
    public int threadCount() {
        return this.threadCount;
    }

    public void startWorkers() {
        if (this.running.getAndSet(true)) {
            return;
        }
        if (!this.threads.isEmpty()) {
            throw new IllegalStateException("Threads are still alive while in the STOPPED state");
        }
        for (int i = 0; i < this.threadCount; ++i) {
            WorkerThread thread = new WorkerThread(this.name + " Task Executor #" + i);
            thread.setPriority(class_3532.method_15340((int)3, (int)1, (int)10));
            thread.start();
            this.threads.add(thread);
        }
        FlwImpl.LOGGER.info("Started {} worker threads", (Object)this.threads.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWorkers() {
        if (!this.running.getAndSet(false)) {
            return;
        }
        if (this.threads.isEmpty()) {
            throw new IllegalStateException("No threads are alive but the executor is in the RUNNING state");
        }
        FlwImpl.LOGGER.info("Stopping worker threads");
        ThreadGroupNotifier threadGroupNotifier = this.taskNotifier;
        synchronized (threadGroupNotifier) {
            this.taskNotifier.notifyAll();
        }
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threads.clear();
        this.taskQueue.clear();
        this.waitGroup._reset();
    }

    @Override
    public void execute(Runnable task) {
        if (!this.running.get()) {
            throw new IllegalStateException("Executor is stopped");
        }
        this.waitGroup.add();
        this.taskQueue.add(task);
        this.taskNotifier.postNotification();
    }

    @Override
    public boolean syncUntil(BooleanSupplier cond) {
        do {
            if (!cond.getAsBoolean()) continue;
            return true;
        } while (!this.syncOneTask());
        return cond.getAsBoolean();
    }

    @Override
    public boolean syncWhile(BooleanSupplier cond) {
        do {
            if (cond.getAsBoolean()) continue;
            return true;
        } while (!this.syncOneTask());
        return !cond.getAsBoolean();
    }

    @Override
    public void syncPoint() {
        while (!this.syncOneTask()) {
        }
    }

    private boolean syncOneTask() {
        Runnable task = this.taskQueue.pollLast();
        if (task != null) {
            this.processTask(task);
            return false;
        }
        return this.waitGroup.await(10000);
    }

    private void processTask(Runnable task) {
        try {
            task.run();
        }
        catch (Exception e) {
            if (this.mainThreadErrorLogLatch > 0) {
                FlwImpl.LOGGER.error("Error running task", (Throwable)e);
                --this.mainThreadErrorLogLatch;
            } else if (this.mainThreadErrorLogLatch == 0) {
                FlwImpl.LOGGER.error("Too many errors emitted by main thread, silencing.");
                --this.mainThreadErrorLogLatch;
            }
        }
        finally {
            this.waitGroup.done();
        }
    }

    private class WorkerThread
    extends Thread {
        private int errorLogLatch;

        public WorkerThread(String name) {
            super(name);
            this.errorLogLatch = 10;
        }

        @Override
        public void run() {
            while (ParallelTaskExecutor.this.running.get()) {
                Runnable task = ParallelTaskExecutor.this.taskQueue.pollFirst();
                if (task != null) {
                    this.processTask(task);
                    continue;
                }
                this.spinThenWait();
            }
        }

        private void processTask(Runnable task) {
            try {
                task.run();
            }
            catch (Exception e) {
                if (this.errorLogLatch > 0) {
                    FlwImpl.LOGGER.error("Error running task", (Throwable)e);
                    --this.errorLogLatch;
                } else if (this.errorLogLatch == 0) {
                    FlwImpl.LOGGER.error("Too many errors emitted by thread {}, silencing.", (Object)this);
                    --this.errorLogLatch;
                }
            }
            finally {
                ParallelTaskExecutor.this.waitGroup.done();
            }
        }

        private void spinThenWait() {
            long waitStart = System.nanoTime();
            while (System.nanoTime() - waitStart < 10000L) {
                if (!ParallelTaskExecutor.this.taskQueue.isEmpty()) {
                    return;
                }
                Thread.onSpinWait();
            }
            ParallelTaskExecutor.this.taskNotifier.awaitNotification();
        }
    }
}

